-- Cria apenas a tabela de notificações WhatsApp
USE `gabinete_bd`;

-- Cria tabela para histórico de notificações WhatsApp
CREATE TABLE IF NOT EXISTS `notificacoes_whatsapp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_agenda` int NOT NULL,
  `telefone_destino` varchar(20) NOT NULL,
  `mensagem` text NOT NULL,
  `status` enum('Pendente','Enviada','Erro','Falhou') NOT NULL DEFAULT 'Pendente',
  `resposta_api` text COMMENT 'Resposta da API do WhatsApp',
  `tentativas` int DEFAULT 0 COMMENT 'Número de tentativas de envio',
  `data_criacao` timestamp DEFAULT CURRENT_TIMESTAMP,
  `data_envio` datetime NULL,
  `erro_detalhes` text COMMENT 'Detalhes do erro se houver',
  PRIMARY KEY (`id`),
  KEY `id_agenda` (`id_agenda`),
  KEY `status` (`status`),
  KEY `data_envio` (`data_envio`),
  CONSTRAINT `notificacoes_whatsapp_ibfk_1` FOREIGN KEY (`id_agenda`) REFERENCES `agendas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;