-- Script para adicionar funcionalidade de notificações WhatsApp
-- Execute este script no phpMyAdmin após o banco principal

USE `gabinete_bd`;

-- Adiciona campo para controlar notificações WhatsApp na tabela agendas
ALTER TABLE `agendas` 
ADD COLUMN `whatsapp_notificacao` TINYINT(1) DEFAULT 0 COMMENT 'Se deve enviar notificação WhatsApp (0=Não, 1=Sim)',
ADD COLUMN `notificacao_enviada` TINYINT(1) DEFAULT 0 COMMENT 'Se a notificação já foi enviada (0=Não, 1=Sim)',
ADD COLUMN `data_notificacao` DATETIME NULL COMMENT 'Data/hora quando a notificação foi enviada';

-- Cria tabela para histórico de notificações WhatsApp
CREATE TABLE IF NOT EXISTS `notificacoes_whatsapp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_agenda` int NOT NULL,
  `telefone_destino` varchar(20) NOT NULL,
  `mensagem` text NOT NULL,
  `status` enum('Pendente','Enviada','Erro','Falhou') NOT NULL DEFAULT 'Pendente',
  `resposta_api` text COMMENT 'Resposta da API do WhatsApp',
  `tentativas` int DEFAULT 0 COMMENT 'Número de tentativas de envio',
  `data_criacao` timestamp DEFAULT CURRENT_TIMESTAMP,
  `data_envio` datetime NULL,
  `erro_detalhes` text COMMENT 'Detalhes do erro se houver',
  PRIMARY KEY (`id`),
  KEY `id_agenda` (`id_agenda`),
  KEY `status` (`status`),
  KEY `data_envio` (`data_envio`),
  CONSTRAINT `notificacoes_whatsapp_ibfk_1` FOREIGN KEY (`id_agenda`) REFERENCES `agendas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Adiciona configurações para WhatsApp na tabela usuarios (para armazenar credenciais da API)
ALTER TABLE `usuarios` 
ADD COLUMN `whatsapp_api_key` varchar(255) NULL COMMENT 'Chave da API WhatsApp (Twilio ou similar)',
ADD COLUMN `whatsapp_account_sid` varchar(255) NULL COMMENT 'Account SID para Twilio',
ADD COLUMN `whatsapp_phone_number` varchar(20) NULL COMMENT 'Número WhatsApp Business para envio';

-- Cria tabela para configurações globais do sistema
CREATE TABLE IF NOT EXISTS `configuracoes_sistema` (
  `id` int NOT NULL AUTO_INCREMENT,
  `chave` varchar(100) NOT NULL UNIQUE,
  `valor` text,
  `descricao` varchar(255),
  `data_atualizacao` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `chave` (`chave`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Insere configurações padrão para WhatsApp
INSERT INTO `configuracoes_sistema` (`chave`, `valor`, `descricao`) VALUES
('whatsapp_ativo', '0', 'Se as notificações WhatsApp estão ativas (0=Não, 1=Sim)'),
('whatsapp_api_provider', 'twilio', 'Provedor da API WhatsApp (twilio, ultramsg, etc)'),
('whatsapp_template_compromisso', 'Olá! Lembrete: Você tem um compromisso agendado para {data} às {hora}. Título: {titulo}. Local: {descricao}', 'Template da mensagem de lembrete'),
('whatsapp_antecedencia_horas', '2', 'Quantas horas antes do compromisso enviar a notificação'),
('whatsapp_horario_inicio', '08:00', 'Horário mínimo para envio de notificações'),
('whatsapp_horario_fim', '20:00', 'Horário máximo para envio de notificações')
ON DUPLICATE KEY UPDATE `valor` = VALUES(`valor`);

COMMIT;