<?php

require_once __DIR__ . '/../config/config.php'; 
require_once __DIR__ . '/../config/log.php'; 

class Usuario {
    private $pdo;

    public function __construct() {
        try {
            $this->pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
            $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) { 
            die("Erro na conexão com o banco de dados: " . $e->getMessage()); 
        }
    }

    public function salvarTokenGoogle($idUsuario, $tokenJson) {
        $sql = "UPDATE usuarios SET google_auth_token = :token WHERE id = :id";
        $stmt = $this->pdo->prepare($sql);
        return $stmt->execute([
            ':token' => $tokenJson,
            ':id' => $idUsuario
        ]);
    }

    public function getTokenGoogle($idUsuario) {
        $sql = "SELECT google_auth_token FROM usuarios WHERE id = :id";
        $stmt = $this->pdo->prepare($sql);
        $stmt->execute([':id' => $idUsuario]);
        $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
        return $resultado ? $resultado['google_auth_token'] : null;
    }

    public function findByEmail($email) {
        $stmt = $this->pdo->prepare("SELECT * FROM usuarios WHERE email = :email AND ativo = 1");
        $stmt->execute(['email' => $email]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function createUser($email, $password) {
        $hashedPassword = password_hash($password, PASSWORD_BCRYPT);
        $stmt = $this->pdo->prepare("INSERT INTO usuarios (email, senha, ativo) VALUES (:email, :senha, 1)");
        try {
            $stmt->execute(['email' => $email, 'senha' => $hashedPassword]);
            return true;
        } catch (PDOException $e) {
            return false;
        }
    }

    public function verificarLogin($email, $senhaDigitada) {
        Logger::log("Iniciando verificação de login para e-mail: " . $email);
        $usuario = $this->findByEmail($email);
        if (!$usuario) { 
            Logger::log("Usuário não encontrado para o e-mail: " . $email);
            return false; 
        }
        $hashSalvoNoBanco = $usuario['senha'];
        if (password_verify($senhaDigitada, $hashSalvoNoBanco)) {
            Logger::log("Senha verificada com sucesso para o usuário: " . $email);
            return $usuario; 
        } else {
            Logger::log("Senha incorreta para o usuário: " . $email);
            return false;
        }
    }

    // NOVOS MÉTODOS PARA O PAINEL ADMIN

    public function getAll() {
        $stmt = $this->pdo->query("SELECT id, nome, email, nivel_acesso, ativo, data_criacao FROM usuarios ORDER BY data_criacao DESC");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function criar($nome, $email, $senha, $nivelAcesso) {
        try {
            $hashedPassword = password_hash($senha, PASSWORD_BCRYPT);
            $stmt = $this->pdo->prepare("INSERT INTO usuarios (nome, email, senha, nivel_acesso, ativo) VALUES (:nome, :email, :senha, :nivel_acesso, 1)");
            return $stmt->execute([
                'nome' => $nome,
                'email' => $email,
                'senha' => $hashedPassword,
                'nivel_acesso' => $nivelAcesso
            ]);
        } catch (PDOException $e) {
            return false;
        }
    }

    public function findById($id) {
        $stmt = $this->pdo->prepare("SELECT * FROM usuarios WHERE id = :id");
        $stmt->execute(['id' => $id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function toggleStatus($id) {
        $stmt = $this->pdo->prepare("UPDATE usuarios SET ativo = NOT ativo WHERE id = :id");
        return $stmt->execute(['id' => $id]);
    }
}
