<div class="content-box">
    <h1><i class="fab fa-whatsapp" style="color: #25D366;"></i> Configurações WhatsApp</h1>
    <p>Configure as credenciais e parâmetros para envio de notificações via WhatsApp.</p>
    
    <?php if (isset($_GET['status'])): ?>
        <?php if ($_GET['status'] === 'success'): ?>
            <div class="alert alert-success">
                <strong>Sucesso!</strong> Configurações WhatsApp salvas com sucesso.
            </div>
        <?php elseif ($_GET['status'] === 'error'): ?>
            <div class="alert alert-danger">
                <strong>Erro!</strong> Falha ao salvar configurações. Verifique os dados informados.
            </div>
        <?php endif; ?>
    <?php endif; ?>
    
    <div class="config-tabs">
        <div class="tab-buttons">
            <button class="tab-button active" onclick="showTab('geral')">Configurações Gerais</button>
            <button class="tab-button" onclick="showTab('twilio')">Credenciais Twilio</button>
            <button class="tab-button" onclick="showTab('teste')">Teste de Envio</button>
            <button class="tab-button" onclick="showTab('historico')">Histórico</button>
        </div>
        
        <!-- Aba Configurações Gerais -->
        <div id="tab-geral" class="tab-content active">
            <form method="POST" action="<?= BASE_URL ?>/configuracoes/salvarWhatsApp">
                <input type="hidden" name="tipo" value="geral">
                
                <div class="form-group">
                    <label class="checkbox-container">
                        <input type="checkbox" name="whatsapp_ativo" value="1" <?= ($config['whatsapp_ativo'] ?? '0') === '1' ? 'checked' : '' ?>>
                        <span class="checkmark"></span>
                        Ativar notificações WhatsApp
                    </label>
                </div>
                
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="antecedencia_horas">Antecedência (horas):</label>
                        <input type="number" id="antecedencia_horas" name="antecedencia_horas" 
                               value="<?= $config['whatsapp_antecedencia_horas'] ?? '2' ?>" 
                               min="1" max="24" class="form-control">
                        <small class="form-text">Quantas horas antes do compromisso enviar a notificação</small>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="api_provider">Provedor da API:</label>
                        <select id="api_provider" name="api_provider" class="form-control">
                            <option value="twilio" <?= ($config['whatsapp_api_provider'] ?? 'twilio') === 'twilio' ? 'selected' : '' ?>>Twilio</option>
                            <option value="ultramsg" <?= ($config['whatsapp_api_provider'] ?? 'twilio') === 'ultramsg' ? 'selected' : '' ?>>UltraMsg (Em breve)</option>
                        </select>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="horario_inicio">Horário início:</label>
                        <input type="time" id="horario_inicio" name="horario_inicio" 
                               value="<?= $config['whatsapp_horario_inicio'] ?? '08:00' ?>" class="form-control">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="horario_fim">Horário fim:</label>
                        <input type="time" id="horario_fim" name="horario_fim" 
                               value="<?= $config['whatsapp_horario_fim'] ?? '20:00' ?>" class="form-control">
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="template_mensagem">Template da mensagem:</label>
                    <textarea id="template_mensagem" name="template_mensagem" rows="4" class="form-control"><?= $config['whatsapp_template_compromisso'] ?? 'Olá! Lembrete: Você tem um compromisso agendado para {data} às {hora}. Título: {titulo}. Local: {descricao}' ?></textarea>
                    <small class="form-text">
                        Variáveis disponíveis: {titulo}, {data}, {hora}, {descricao}, {categoria}
                    </small>
                </div>
                
                <button type="submit" class="btn btn-primary">Salvar Configurações Gerais</button>
            </form>
        </div>
        
        <!-- Aba Credenciais Twilio -->
        <div id="tab-twilio" class="tab-content">
            <div class="info-box">
                <h3><i class="fas fa-info-circle"></i> Como configurar Twilio</h3>
                <ol>
                    <li>Acesse <a href="https://console.twilio.com" target="_blank">console.twilio.com</a></li>
                    <li>Crie uma conta ou faça login</li>
                    <li>Vá em <strong>Develop > Messaging > Try it out > Send a WhatsApp message</strong></li>
                    <li>Copie o <strong>Account SID</strong> e <strong>Auth Token</strong></li>
                    <li>Configure um número WhatsApp Business</li>
                </ol>
            </div>
            
            <form method="POST" action="<?= BASE_URL ?>/configuracoes/salvarWhatsApp">
                <input type="hidden" name="tipo" value="twilio">
                
                <div class="form-group">
                    <label for="twilio_account_sid">Account SID:</label>
                    <input type="text" id="twilio_account_sid" name="twilio_account_sid" 
                           value="<?= $credenciais['whatsapp_account_sid'] ?? '' ?>" 
                           class="form-control" placeholder="ACxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx">
                </div>
                
                <div class="form-group">
                    <label for="twilio_auth_token">Auth Token:</label>
                    <input type="password" id="twilio_auth_token" name="twilio_auth_token" 
                           value="<?= $credenciais['whatsapp_api_key'] ?? '' ?>" 
                           class="form-control" placeholder="Seu Auth Token">
                </div>
                
                <div class="form-group">
                    <label for="twilio_phone_number">Número WhatsApp:</label>
                    <input type="text" id="twilio_phone_number" name="twilio_phone_number" 
                           value="<?= $credenciais['whatsapp_phone_number'] ?? '' ?>" 
                           class="form-control" placeholder="+14155238886">
                    <small class="form-text">Número fornecido pelo Twilio (formato: +14155238886)</small>
                </div>
                
                <button type="submit" class="btn btn-primary">Salvar Credenciais Twilio</button>
            </form>
        </div>
        
        <!-- Aba Teste de Envio -->
        <div id="tab-teste" class="tab-content">
            <div class="alert alert-warning">
                <strong>Atenção:</strong> Use esta função apenas para testes. Cada mensagem enviada consome créditos da sua conta Twilio.
            </div>
            
            <form method="POST" action="<?= BASE_URL ?>/configuracoes/testarWhatsApp">
                <div class="form-group">
                    <label for="telefone_teste">Telefone de teste:</label>
                    <input type="text" id="telefone_teste" name="telefone_teste" 
                           class="form-control" placeholder="+5511999999999" required>
                    <small class="form-text">Formato internacional com código do país</small>
                </div>
                
                <div class="form-group">
                    <label for="mensagem_teste">Mensagem de teste:</label>
                    <textarea id="mensagem_teste" name="mensagem_teste" rows="3" 
                              class="form-control" required>Esta é uma mensagem de teste do Sistema de Gabinete. Se você recebeu esta mensagem, a configuração está funcionando corretamente!</textarea>
                </div>
                
                <button type="submit" class="btn btn-warning">Enviar Teste</button>
            </form>
        </div>
        
        <!-- Aba Histórico -->
        <div id="tab-historico" class="tab-content">
            <div class="stats-cards">
                <div class="stat-card">
                    <div class="stat-number"><?= $estatisticas['total_enviadas'] ?? 0 ?></div>
                    <div class="stat-label">Mensagens Enviadas</div>
                </div>
                <div class="stat-card">
                    <div class="stat-number"><?= $estatisticas['total_erros'] ?? 0 ?></div>
                    <div class="stat-label">Erros</div>
                </div>
                <div class="stat-card">
                    <div class="stat-number"><?= $estatisticas['taxa_sucesso'] ?? 0 ?>%</div>
                    <div class="stat-label">Taxa de Sucesso</div>
                </div>
            </div>
            
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Data/Hora</th>
                            <th>Telefone</th>
                            <th>Status</th>
                            <th>Compromisso</th>
                            <th>Tentativas</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($historico)): ?>
                            <?php foreach ($historico as $item): ?>
                                <tr>
                                    <td><?= date('d/m/Y H:i', strtotime($item['data_criacao'])) ?></td>
                                    <td><?= $item['telefone_destino'] ?></td>
                                    <td>
                                        <span class="status-badge status-<?= strtolower($item['status']) ?>">
                                            <?= $item['status'] ?>
                                        </span>
                                    </td>
                                    <td><?= $item['titulo_compromisso'] ?? 'N/A' ?></td>
                                    <td><?= $item['tentativas'] ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="text-center">Nenhuma notificação encontrada</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<style>
.config-tabs {
    margin-top: 20px;
}

.tab-buttons {
    display: flex;
    border-bottom: 2px solid #ddd;
    margin-bottom: 20px;
}

.tab-button {
    background: none;
    border: none;
    padding: 12px 20px;
    cursor: pointer;
    font-size: 14px;
    color: #666;
    border-bottom: 2px solid transparent;
    transition: all 0.3s;
}

.tab-button:hover {
    color: #333;
    background-color: #f8f9fa;
}

.tab-button.active {
    color: #007bff;
    border-bottom-color: #007bff;
    font-weight: 600;
}

.tab-content {
    display: none;
}

.tab-content.active {
    display: block;
}

.info-box {
    background: #f8f9fa;
    border: 1px solid #dee2e6;
    border-radius: 5px;
    padding: 20px;
    margin-bottom: 20px;
}

.info-box h3 {
    color: #495057;
    margin-bottom: 15px;
}

.info-box ol {
    margin-bottom: 0;
}

.stats-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-bottom: 30px;
}

.stat-card {
    background: white;
    border: 1px solid #dee2e6;
    border-radius: 8px;
    padding: 20px;
    text-align: center;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.stat-number {
    font-size: 2.5em;
    font-weight: bold;
    color: #007bff;
    margin-bottom: 5px;
}

.stat-label {
    color: #6c757d;
    font-size: 14px;
}

.status-badge {
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.status-enviada {
    background-color: #d4edda;
    color: #155724;
}

.status-erro, .status-falhou {
    background-color: #f8d7da;
    color: #721c24;
}

.status-pendente {
    background-color: #fff3cd;
    color: #856404;
}
</style>

<script>
function showTab(tabName) {
    // Esconde todas as abas
    const tabs = document.querySelectorAll('.tab-content');
    tabs.forEach(tab => tab.classList.remove('active'));
    
    // Remove classe active de todos os botões
    const buttons = document.querySelectorAll('.tab-button');
    buttons.forEach(button => button.classList.remove('active'));
    
    // Mostra a aba selecionada
    document.getElementById('tab-' + tabName).classList.add('active');
    
    // Adiciona classe active ao botão clicado
    event.target.classList.add('active');
}
</script>