<div class="content-box">
    <h1>Lista de Eleitores</h1>
    
    <!-- Campo de Busca -->
    <div class="search-container">
        <form method="GET" action="<?= BASE_URL ?>/eleitores" class="search-form">
            <div class="search-input-group">
                <input type="text" name="busca" placeholder="Buscar por nome, telefone ou bairro..." 
                       value="<?= htmlspecialchars($_GET['busca'] ?? '') ?>" class="search-input">
                <button type="submit" class="btn btn-search">
                    <i class="fas fa-search"></i> Buscar
                </button>
                <?php if (!empty($_GET['busca'])): ?>
                    <a href="<?= BASE_URL ?>/eleitores" class="btn btn-clear">
                        <i class="fas fa-times"></i> Limpar
                    </a>
                <?php endif; ?>
            </div>
        </form>
    </div>
    
    <a href="<?= BASE_URL ?>/eleitores/cadastrar" class="btn btn-add">
        <i class="fas fa-plus"></i> Adicionar Novo Eleitor
    </a>

    <table>
        <thead>
            <tr>
                <th>Nome Completo</th>
                <th>Telefone</th>
                <th>Bairro</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($eleitores) > 0): ?>
                <?php foreach ($eleitores as $eleitor): ?>
                    <tr>
                        <td><?= htmlspecialchars($eleitor['nome_completo']) ?></td>
                        <td><?= htmlspecialchars($eleitor['telefone']) ?></td>
                        <td><?= htmlspecialchars($eleitor['bairro']) ?></td>
                        <td class="actions">
                            <a href="<?= BASE_URL ?>/eleitores/ver/<?= $eleitor['id'] ?>" title="Ver Detalhes"><i class="fas fa-eye"></i></a>
                            <a href="<?= BASE_URL ?>/eleitores/editar/<?= $eleitor['id'] ?>" title="Editar"><i class="fas fa-edit"></i></a>
                            <a href="<?= BASE_URL ?>/eleitores/excluir/<?= $eleitor['id'] ?>" class="delete-link" title="Excluir"><i class="fas fa-trash"></i></a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="4">
                        <?php if (!empty($_GET['busca'])): ?>
                            Nenhum eleitor encontrado para "<?= htmlspecialchars($_GET['busca']) ?>".
                        <?php else: ?>
                            Nenhum eleitor cadastrado.
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>