<?php
session_start();
require_once 'src/config/config.php';
require_once 'src/models/Usuario.php';

// Simular login
$pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
$stmt = $pdo->prepare("SELECT * FROM usuarios WHERE email = :email AND ativo = 1");
$stmt->execute(['email' => 'admin@gabinete.com']);
$usuario = $stmt->fetch(PDO::FETCH_ASSOC);

if ($usuario && password_verify('admin123', $usuario['senha'])) {
    $_SESSION['logado'] = true;
    $_SESSION['usuario_id'] = $usuario['id'];
    $_SESSION['usuario_nome'] = $usuario['nome'];
    $_SESSION['usuario_email'] = $usuario['email'];
    $_SESSION['usuario_nivel_acesso'] = $usuario['nivel_acesso'];
}

echo "<h2>Teste de Links do Menu</h2>";
echo "<p>Status do login: " . (isset($_SESSION['logado']) && $_SESSION['logado'] ? '✅ Logado' : '❌ Não logado') . "</p>";

if (isset($_SESSION['logado']) && $_SESSION['logado']) {
    echo "<h3>Links do Menu (clique para testar):</h3>";
    echo "<ul>";
    echo "<li><a href='" . BASE_URL . "/' target='_blank'>🏠 Página Principal (Agenda)</a></li>";
    echo "<li><a href='" . BASE_URL . "/agendas' target='_blank'>📅 Agendas</a></li>";
    echo "<li><a href='" . BASE_URL . "/documentos' target='_blank'>📄 Documentos</a></li>";
    echo "<li><a href='" . BASE_URL . "/eleitores' target='_blank'>👥 Eleitores</a></li>";
    echo "<li><a href='" . BASE_URL . "/employees' target='_blank'>👔 RH (Colaboradores)</a></li>";
    echo "<li><a href='" . BASE_URL . "/relatorios' target='_blank'>📊 Relatórios</a></li>";
    echo "<li><a href='" . BASE_URL . "/configuracoes' target='_blank'>⚙️ Configurações</a></li>";
    echo "<li><a href='" . BASE_URL . "/paineladmin' target='_blank'>🛡️ Painel Admin</a></li>";
    echo "</ul>";
    
    echo "<h3>Teste de Roteamento:</h3>";
    $testUrls = [
        '/documentos' => 'DocumentosController',
        '/eleitores' => 'EleitoresController', 
        '/employees' => 'EmployeesController',
        '/relatorios' => 'RelatoriosController',
        '/configuracoes' => 'ConfiguracoesController'
    ];
    
    foreach ($testUrls as $url => $expectedController) {
        $fullUrl = BASE_URL . $url;
        echo "<p>";
        echo "<strong>" . $url . "</strong> → ";
        echo "<a href='" . $fullUrl . "' target='_blank'>Testar</a> ";
        echo "(Esperado: " . $expectedController . ")";
        echo "</p>";
    }
    
    echo "<h3>Informações de Debug:</h3>";
    echo "<p>BASE_URL: " . BASE_URL . "</p>";
    echo "<p>Session ID: " . session_id() . "</p>";
    echo "<p>Usuário: " . $_SESSION['usuario_nome'] . " (" . $_SESSION['usuario_email'] . ")</p>";
    echo "<p>Nível: " . $_SESSION['usuario_nivel_acesso'] . "</p>";
} else {
    echo "<p style='color: red;'>❌ Não foi possível fazer login. Verifique as credenciais.</p>";
}
?>