<?php
// gen_hash.php - Ferramenta de Criação de Usuários

// Habilitar exibição de erros para debug
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Carregar configurações e modelos
require_once __DIR__ . '/src/config/config.php';
require_once __DIR__ . '/src/models/Usuario.php';

$mensagem = '';
$tipoMensagem = '';
$hashGerado = '';

// Instanciar modelo
$usuarioModel = new Usuario();
$niveis = $usuarioModel->getNiveisAcesso();

// Processar formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome = $_POST['nome'] ?? '';
    $email = $_POST['email'] ?? '';
    $senha = $_POST['senha'] ?? '';
    $nivel = $_POST['nivel'] ?? '';

    if (!empty($nome) && !empty($email) && !empty($senha) && !empty($nivel)) {
        // Tentar criar usuário
        if ($usuarioModel->criar($nome, $email, $senha, $nivel)) {
            $mensagem = "Usuário <strong>" . htmlspecialchars($nome) . "</strong> criado com sucesso!";
            $tipoMensagem = 'success';
            $hashGerado = password_hash($senha, PASSWORD_BCRYPT);
        } else {
            $mensagem = "Erro ao criar usuário. O e-mail já pode estar em uso.";
            $tipoMensagem = 'danger';
        }
    } else {
        $mensagem = "Por favor, preencha todos os campos.";
        $tipoMensagem = 'warning';
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerador de Usuários - Gabinete</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            padding-top: 50px;
        }

        .card {
            max-width: 500px;
            margin: 0 auto;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .card-header {
            background-color: #0d6efd;
            color: white;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="card">
            <div class="card-header text-center">
                <i class="bi bi-person-plus-fill"></i> Criar Novo Usuário
            </div>
            <div class="card-body">
                <?php if ($mensagem): ?>
                    <div class="alert alert-<?= $tipoMensagem ?> alert-dismissible fade show" role="alert">
                        <?= $mensagem ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <?php if ($hashGerado): ?>
                    <div class="alert alert-info">
                        <strong>Hash gerado (para referência):</strong><br>
                        <small class="text-break"><?= $hashGerado ?></small>
                    </div>
                <?php endif; ?>

                <form method="POST">
                    <div class="mb-3">
                        <label for="nome" class="form-label">Nome Completo</label>
                        <input type="text" class="form-control" id="nome" name="nome" required>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">E-mail</label>
                        <input type="email" class="form-control" id="email" name="email" required>
                    </div>
                    <div class="mb-3">
                        <label for="senha" class="form-label">Senha</label>
                        <input type="text" class="form-control" id="senha" name="senha" required>
                    </div>
                    <div class="mb-3">
                        <label for="nivel" class="form-label">Nível de Acesso</label>
                        <select class="form-select" id="nivel" name="nivel" required>
                            <option value="">Selecione...</option>
                            <?php foreach ($niveis as $chave => $descricao): ?>
                                <option value="<?= htmlspecialchars($chave) ?>"><?= htmlspecialchars($descricao) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-primary">Criar Usuário</button>
                        <a href="login.php" class="btn btn-outline-secondary">Ir para Login</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>