<?php
require_once __DIR__ . '/env.php';

// Define fuso horário
date_default_timezone_set('America/Sao_Paulo'); // Ajuste conforme necessário

// Definições de Banco de Dados (pegando do env.php)
if (!defined('DB_HOST'))
    define('DB_HOST', getenv('DB_HOST') ?: '127.0.0.1');
if (!defined('DB_PORT'))
    define('DB_PORT', getenv('DB_PORT') ?: '3306');
if (!defined('DB_NAME'))
    define('DB_NAME', getenv('DB_NAME') ?: 'gabinete_bd');
if (!defined('DB_USER'))
    define('DB_USER', getenv('DB_USER') ?: 'root');
if (!defined('DB_PASS'))
    define('DB_PASS', getenv('DB_PASS') ?: '');
if (!defined('DB_SOCKET'))
    define('DB_SOCKET', getenv('DB_SOCKET') ?: '');

// Retorna array de configuração para quem precisar (ex: login.php)
return [
    'timezone' => 'America/Sao_Paulo',
    'database' => [
        'host' => DB_HOST,
        'port' => DB_PORT,
        'database' => DB_NAME,
        'username' => DB_USER,
        'password' => DB_PASS,
        'charset' => 'utf8mb4'
    ]
];