<?php
// Carrega os models e helpers necessários.
require_once __DIR__ . '/../models/Relatorio.php';
// ADICIONADO: A linha que faltava para incluir o helper de autenticação.
require_once __DIR__ . '/../helpers/AuthHelper.php';

class RelatoriosController
{

    public function index()
    {
        // Esta linha agora funcionará porque o AuthHelper foi incluído.
        AuthHelper::check();

        $relatorioModel = new Relatorio();

        // Coleta todos os dados do model
        $dados = [
            'totalEleitores' => $relatorioModel->getTotalEleitores(),
            'porSexo' => $relatorioModel->getContagemPorSexo(),
            'porBairro' => $relatorioModel->getContagemPorBairro(),
            'porTipo' => $relatorioModel->getContagemPorTipo(),
            'porDemanda' => $relatorioModel->getContagemPorDemanda(),
            'porDemandaEleitores' => $relatorioModel->getContagemPorDemandaEleitores(),
            'eleitoresRecentes' => $relatorioModel->getEleitoresRecentes()
        ];

        $pageTitle = "Relatórios e Estatísticas";

        require_once __DIR__ . '/../views/relatorios/relatorio.php';
    }

    public function porUsuario()
    {
        AuthHelper::check();
        $relatorioModel = new Relatorio();
        $dados = $relatorioModel->getContagemPorUsuario();

        $pageTitle = "Relatório de Cadastros por Usuário";

        require_once __DIR__ . '/../views/relatorios/por_usuario.php';
    }

    public function liderancas()
    {
        AuthHelper::check();
        $relatorioModel = new Relatorio();
        $liderancas = $relatorioModel->getLiderancas();
        $debugData = $relatorioModel->getDebugEleitores(); // Debug

        $pageTitle = "Lista de Lideranças";

        require_once __DIR__ . '/../views/relatorios/liderancas.php';
    }
}
