<?php
$pageTitle = "Acesso Negado";
require_once __DIR__ . '/partials/header.php';
?>

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card border-danger">
                <div class="card-header bg-danger text-white text-center">
                    <h4><i class="fas fa-exclamation-triangle"></i> Acesso Negado</h4>
                </div>
                <div class="card-body text-center">
                    <div class="mb-4">
                        <i class="fas fa-lock" style="font-size: 4rem; color: #dc3545;"></i>
                    </div>
                    <h5 class="card-title">Você não tem permissão para acessar esta página</h5>
                    <p class="card-text text-muted">
                        Seu nível de acesso não permite visualizar ou executar esta ação. 
                        Entre em contato com o administrador do sistema se você acredita que deveria ter acesso.
                    </p>
                    
                    <div class="mt-4">
                        <a href="<?= BASE_URL ?>" class="btn btn-primary">
                            <i class="fas fa-home"></i> Voltar ao Início
                        </a>
                        <button onclick="history.back()" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Voltar
                        </button>
                    </div>
                </div>
                <div class="card-footer text-muted text-center">
                    <small>
                        <i class="fas fa-info-circle"></i> 
                        Seu nível de acesso atual: <strong><?= PermissionHelper::getNomeNivelAcesso($_SESSION['nivel_acesso'] ?? 'Não definido') ?></strong>
                    </small>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/partials/footer.php'; ?>