<div class="content-box">
    <h1><i class="fas fa-users-cog"></i> Gerenciar Usuários</h1>
    
    <div class="page-actions">
        <a href="<?= BASE_URL ?>/paineladmin/criarUsuario" class="btn btn-success">
            <i class="fas fa-user-plus"></i> Criar Novo Usuário
        </a>
        <a href="<?= BASE_URL ?>/paineladmin" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Voltar ao Painel
        </a>
    </div>

    <form action="<?= BASE_URL ?>/paineladmin/usuarios" method="GET" class="mb-3 p-3 border rounded bg-light">
        <div class="row g-2">
            <div class="col-md-3">
                <label class="form-label">Busca</label>
                <input type="text" name="q" value="<?= htmlspecialchars($q ?? '') ?>" class="form-control" placeholder="Nome ou e-mail">
            </div>
            <div class="col-md-3">
                <label class="form-label">Nível de Acesso</label>
                <select name="nivel" class="form-select">
                    <option value="">Todos</option>
                    <?php if (!empty($niveisDistinct)): ?>
                        <?php foreach ($niveisDistinct as $n): ?>
                            <option value="<?= htmlspecialchars($n) ?>" <?= (isset($nivel) && $nivel === $n) ? 'selected' : '' ?>><?= htmlspecialchars($n) ?></option>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="">Todos</option>
                    <option value="ativo" <?= (isset($status) && $status === 'ativo') ? 'selected' : '' ?>>Ativo</option>
                    <option value="inativo" <?= (isset($status) && $status === 'inativo') ? 'selected' : '' ?>>Inativo</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Ordenar por</label>
                <select name="sortBy" class="form-select">
                    <?php $allowedSort = ['data_criacao' => 'Data', 'nome' => 'Nome', 'email' => 'Email', 'nivel_acesso' => 'Nível', 'ativo' => 'Status', 'id' => 'ID']; ?>
                    <?php foreach ($allowedSort as $key => $label): ?>
                        <option value="<?= $key ?>" <?= (isset($sortBy) && $sortBy === $key) ? 'selected' : '' ?>><?= $label ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Direção</label>
                <select name="sortDir" class="form-select">
                    <option value="DESC" <?= (isset($sortDir) && strtoupper($sortDir) === 'DESC') ? 'selected' : '' ?>>Desc</option>
                    <option value="ASC" <?= (isset($sortDir) && strtoupper($sortDir) === 'ASC') ? 'selected' : '' ?>>Asc</option>
                </select>
            </div>
        </div>
        <div class="mt-3 d-flex gap-2">
            <button type="submit" class="btn btn-primary"><i class="fas fa-filter"></i> Filtrar</button>
            <a href="<?= BASE_URL ?>/paineladmin/usuarios" class="btn btn-outline-secondary">Limpar</a>
        </div>
    </form>

    <?php if (isset($_SESSION['success_message'])): ?>
        <div class="alert alert-success">
            <?= $_SESSION['success_message'] ?>
            <?php unset($_SESSION['success_message']); ?>
        </div>
    <?php endif; ?>

    <?php if (isset($_SESSION['error_message'])): ?>
        <div class="alert alert-danger">
            <?= $_SESSION['error_message'] ?>
            <?php unset($_SESSION['error_message']); ?>
        </div>
    <?php endif; ?>

    <div class="users-table">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nome</th>
                    <th>Email</th>
                    <th>Nível de Acesso</th>
                    <th>Status</th>
                    <th>Data de Criação</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php if (isset($usuarios) && count($usuarios) > 0): ?>
                    <?php foreach ($usuarios as $usuario): ?>
                    <tr>
                        <td><?= $usuario['id'] ?></td>
                        <td><?= htmlspecialchars($usuario['nome']) ?></td>
                        <td><?= htmlspecialchars($usuario['email']) ?></td>
                        <td>
                            <span class="badge badge-<?= strtolower($usuario['nivel_acesso']) ?>">
                                <?= $usuario['nivel_acesso'] ?>
                            </span>
                        </td>
                        <td>
                            <span class="status-badge <?= $usuario['ativo'] ? 'active' : 'inactive' ?>">
                                <?= $usuario['ativo'] ? 'Ativo' : 'Inativo' ?>
                            </span>
                        </td>
                        <td><?= date('d/m/Y', strtotime($usuario['data_criacao'])) ?></td>
                        <td class="actions">
                            <?php if ($usuario['id'] != $_SESSION['usuario_id']): ?>
                                <a href="<?= BASE_URL ?>/paineladmin/editarUsuario/<?= $usuario['id'] ?>" 
                                   title="Editar" class="btn-action btn-edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="<?= BASE_URL ?>/paineladmin/toggleUsuario" method="POST" style="display:inline;">
                                    <input type="hidden" name="usuario_id" value="<?= $usuario['id'] ?>">
                                    <button type="submit"
                                            title="<?= $usuario['ativo'] ? 'Desativar' : 'Ativar' ?>" 
                                            class="btn-action btn-toggle">
                                        <i class="fas fa-<?= $usuario['ativo'] ? 'ban' : 'check' ?>"></i>
                                    </button>
                                </form>
                            <?php else: ?>
                                <span class="text-muted">Você mesmo</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" class="text-center">Nenhum usuário encontrado.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<style>
.page-actions {
    margin-bottom: 20px;
    display: flex;
    gap: 10px;
}

.btn-secondary {
    background-color: #6c757d;
    color: white;
}

.users-table {
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.status-badge {
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 0.8em;
    font-weight: bold;
}

.status-badge.active {
    background-color: #d4edda;
    color: #155724;
}

.status-badge.inactive {
    background-color: #f8d7da;
    color: #721c24;
}

.btn-action {
    display: inline-block;
    padding: 5px 8px;
    margin: 0 2px;
    border-radius: 3px;
    text-decoration: none;
    font-size: 0.9em;
}

.btn-edit {
    background-color: #ffc107;
    color: #212529;
}

.btn-toggle {
    background-color: #17a2b8;
    color: white;
}

.text-center {
    text-align: center;
}

.text-muted {
    color: #6c757d;
    font-style: italic;
}
</style>
