<?php
require 'db.php';

// Verificar se foi solicitada geração de relatório
if (isset($_GET['gerar'])) {
    $tipo = $_GET['gerar'];
    $ano = isset($_GET['ano']) ? (int)$_GET['ano'] : date('Y');
    $mes = isset($_GET['mes']) ? (int)$_GET['mes'] : 0;

    // Filtro de data
    $filtro_sql = $mes == 0 ? "WHERE YEAR(data_transacao) = $ano" : "WHERE YEAR(data_transacao) = $ano AND MONTH(data_transacao) = $mes";

    if ($tipo == 'excel') {
        gerarExcel($conexao, $filtro_sql, $ano, $mes);
    } elseif ($tipo == 'pdf') {
        gerarPDF($conexao, $filtro_sql, $ano, $mes);
    }
}

function gerarExcel($conexao, $filtro_sql, $ano, $mes) {
    $nomes_meses = [1=>'Janeiro',2=>'Fevereiro',3=>'Março',4=>'Abril',5=>'Maio',6=>'Junho',7=>'Julho',8=>'Agosto',9=>'Setembro',10=>'Outubro',11=>'Novembro',12=>'Dezembro'];
    $periodo = $mes == 0 ? "Anual_$ano" : $nomes_meses[$mes] . "_$ano";

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="Relatorio_Financeiro_' . $periodo . '.xls"');
    header('Cache-Control: max-age=0');

    echo "<table border='1'>";
    echo "<tr><th colspan='7' style='text-align:center; font-size:16px; font-weight:bold;'>Relatório Financeiro - $periodo</th></tr>";
    echo "<tr><th>Data</th><th>Tipo</th><th>Origem</th><th>Descrição</th><th>Entidade</th><th>Forma Pagamento</th><th>Valor</th></tr>";

    $transacoes = $conexao->query("SELECT * FROM transacoes $filtro_sql ORDER BY data_transacao DESC");
    $total_receitas = 0;
    $total_despesas = 0;

    while ($t = $transacoes->fetch_assoc()) {
        $valor_formatado = number_format($t['valor'], 2, ',', '.');
        if ($t['tipo'] == 'Receita') {
            $total_receitas += $t['valor'];
            $valor_display = "+ R$ $valor_formatado";
        } else {
            $total_despesas += $t['valor'];
            $valor_display = "- R$ $valor_formatado";
        }

        echo "<tr>";
        echo "<td>" . date("d/m/Y", strtotime($t['data_transacao'])) . "</td>";
        echo "<td>" . $t['tipo'] . "</td>";
        echo "<td>" . htmlspecialchars($t['origem']) . "</td>";
        echo "<td>" . htmlspecialchars($t['descricao']) . "</td>";
        echo "<td>" . htmlspecialchars($t['entidade'] ?? '-') . "</td>";
        echo "<td>" . htmlspecialchars($t['forma_pagamento'] ?? '-') . "</td>";
        echo "<td>$valor_display</td>";
        echo "</tr>";
    }

    $saldo = $total_receitas - $total_despesas;
    echo "<tr><td colspan='6' style='font-weight:bold; text-align:right;'>Total Receitas:</td><td style='font-weight:bold; color:green;'>R$ " . number_format($total_receitas, 2, ',', '.') . "</td></tr>";
    echo "<tr><td colspan='6' style='font-weight:bold; text-align:right;'>Total Despesas:</td><td style='font-weight:bold; color:red;'>R$ " . number_format($total_despesas, 2, ',', '.') . "</td></tr>";
    echo "<tr><td colspan='6' style='font-weight:bold; text-align:right;'>Saldo Final:</td><td style='font-weight:bold; color:blue;'>R$ " . number_format($saldo, 2, ',', '.') . "</td></tr>";
    echo "</table>";
    exit();
}

function gerarPDF($conexao, $filtro_sql, $ano, $mes) {
    $nomes_meses = [1=>'Janeiro',2=>'Fevereiro',3=>'Março',4=>'Abril',5=>'Maio',6=>'Junho',7=>'Julho',8=>'Agosto',9=>'Setembro',10=>'Outubro',11=>'Novembro',12=>'Dezembro'];
    $periodo = $mes == 0 ? "Relatório Anual de $ano" : "Relatório de " . $nomes_meses[$mes] . " de $ano";

    header('Content-Type: text/html; charset=utf-8');
    header('Content-Disposition: attachment; filename="Relatorio_' . ($mes == 0 ? "Anual_$ano" : $nomes_meses[$mes] . "_$ano") . '.html"');

    echo "<!DOCTYPE html><html><head><meta charset='utf-8'><title>$periodo</title>";
    echo "<style>body{font-family:Arial,sans-serif;margin:20px;}table{width:100%;border-collapse:collapse;}th,td{border:1px solid #ddd;padding:8px;text-align:left;}th{background-color:#f2f2f2;}</style>";
    echo "</head><body>";
    echo "<h1>Financeiro</h1>";
    echo "<h2>$periodo</h2>";

    $receitas = $conexao->query("SELECT SUM(valor) as total FROM transacoes $filtro_sql AND tipo = 'Receita'")->fetch_assoc()['total'] ?? 0;
    $despesas = $conexao->query("SELECT SUM(valor) as total FROM transacoes $filtro_sql AND tipo = 'Despesa'")->fetch_assoc()['total'] ?? 0;
    $saldo = $receitas - $despesas;

    echo "<table><tr><th>Resumo Financeiro</th><th>Valor</th></tr>";
    echo "<tr><td>Total de Receitas</td><td style='color:green;'>R$ " . number_format($receitas, 2, ',', '.') . "</td></tr>";
    echo "<tr><td>Total de Despesas</td><td style='color:red;'>R$ " . number_format($despesas, 2, ',', '.') . "</td></tr>";
    echo "<tr><td><strong>Saldo Final</strong></td><td style='color:blue;'><strong>R$ " . number_format($saldo, 2, ',', '.') . "</strong></td></tr>";
    echo "</table><br>";

    echo "<h3>Detalhamento das Transações</h3>";
    echo "<table><tr><th>Data</th><th>Tipo</th><th>Descrição</th><th>Entidade</th><th>Valor</th></tr>";

    $transacoes = $conexao->query("SELECT * FROM transacoes $filtro_sql ORDER BY data_transacao DESC");
    while ($t = $transacoes->fetch_assoc()) {
        $cor = $t['tipo'] == 'Receita' ? 'green' : 'red';
        $sinal = $t['tipo'] == 'Receita' ? '+' : '-';
        echo "<tr>";
        echo "<td>" . date("d/m/Y", strtotime($t['data_transacao'])) . "</td>";
        echo "<td>" . $t['tipo'] . "</td>";
        echo "<td>" . htmlspecialchars($t['descricao']) . "</td>";
        echo "<td>" . htmlspecialchars($t['entidade'] ?? '-') . "</td>";
        echo "<td style='color:$cor;'>$sinal R$ " . number_format($t['valor'], 2, ',', '.') . "</td>";
        echo "</tr>";
    }
    echo "</table></body></html>";
    exit();
}

// Buscar dados para os gráficos
$ano_atual = date('Y');
$dados_mensais = [];
for ($i = 1; $i <= 12; $i++) {
    $receitas = $conexao->query("SELECT SUM(valor) as total FROM transacoes WHERE YEAR(data_transacao) = $ano_atual AND MONTH(data_transacao) = $i AND tipo = 'Receita'")->fetch_assoc()['total'] ?? 0;
    $despesas = $conexao->query("SELECT SUM(valor) as total FROM transacoes WHERE YEAR(data_transacao) = $ano_atual AND MONTH(data_transacao) = $i AND tipo = 'Despesa'")->fetch_assoc()['total'] ?? 0;
    $dados_mensais[] = ['mes' => $i, 'receitas' => (float)$receitas, 'despesas' => (float)$despesas];
}

// Dados por origem
$dados_origem = $conexao->query("
    SELECT origem, SUM(valor) as total, tipo 
    FROM transacoes 
    WHERE YEAR(data_transacao) = $ano_atual 
    GROUP BY origem, tipo 
    ORDER BY total DESC
")->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>📊 Relatórios - Gabinete</title>
  
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="css/styles.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels@2.0.0"></script>


</head>
<body>

<div class="header">
  <div class="header-content">
    <div class="title-section">
      <h1><i class="fas fa-chart-bar"></i>Relatórios</h1>
      <p>Análise Completa e Exportação de Dados</p>
    </div>
    <a href="http://localhost:8888/gabinete/" class="nav-link nav-primary nav-push-right" title="Home" aria-label="Home">
      <i class="fa-solid fa-house"></i>
    </a>
  </div>
</div>

<div class="container">
  <div class="navigation">
    <a href="index.php" class="nav-link nav-primary">
      <i class="fas fa-plus-circle"></i>Lançar Contas
    </a>
    <a href="contas.php" class="nav-link nav-green">
      <i class="fas fa-list-check"></i>Controle de Contas
    </a>
    <a href="relatorios.php" class="nav-link nav-amber active">
      <i class="fas fa-chart-bar"></i>Relatórios
    </a>
    <a href="http://localhost:8888/gabinete/" class="nav-link nav-primary nav-push-right" title="Voltar ao Sistema Principal" aria-label="Home">
      <i class="fas fa-home"></i>Sistema Principal
    </a>
  </div>

  <div class="form-container">
    <h2>Gerar Relatórios</h2>
    <form action="relatorios.php" method="GET">
      <div class="form-row">
        <div class="form-group">
          <label for="ano"><i class="fas fa-calendar-year"></i>Ano</label>
          <select name="ano" id="ano">
            <?php for ($ano = date('Y'); $ano >= date('Y') - 5; $ano--): ?>
              <option value="<?= $ano ?>"><?= $ano ?></option>
            <?php endfor; ?>
          </select>
        </div>
        <div class="form-group">
          <label for="mes"><i class="fas fa-calendar"></i>Mês</label>
          <select name="mes" id="mes">
            <option value="0">Todos os Meses (Anual)</option>
            <option value="1">Janeiro</option><option value="2">Fevereiro</option><option value="3">Março</option>
            <option value="4">Abril</option><option value="5">Maio</option><option value="6">Junho</option>
            <option value="7">Julho</option><option value="8">Agosto</option><option value="9">Setembro</option>
            <option value="10">Outubro</option><option value="11">Novembro</option><option value="12">Dezembro</option>
          </select>
        </div>
        <div class="form-group">
          <button type="submit" name="gerar" value="pdf" class="btn btn-amber">
            <i class="fas fa-file-pdf"></i>Gerar PDF
          </button>
        </div>
        <div class="form-group">
          <button type="submit" name="gerar" value="excel" class="btn btn-green">
            <i class="fas fa-file-excel"></i>Gerar Excel
          </button>
        </div>
      </div>
    </form>
  </div>

  <div class="charts-container">
    <div class="chart-box">
      <h3><i class="fas fa-chart-line"></i>Evolução Mensal <?= (int)$ano_atual ?></h3>
      <canvas id="chartMensal" width="400" height="200"></canvas>
    </div>

    <div class="chart-box">
      <h3><i class="fas fa-chart-pie"></i>Distribuição por Origem</h3>
      <canvas id="chartOrigem" width="400" height="200"></canvas>
    </div>
  </div>

  <div class="chart-box" style="margin-top: 30px;">
    <h3><i class="fas fa-chart-bar"></i>Comparativo Receitas vs Despesas</h3>
    <canvas id="chartComparativo" width="800" height="300"></canvas>
  </div>

</div>

<script>
/* Registrar plugin de labels */
Chart.register(ChartDataLabels);

const dadosMensais = <?= json_encode($dados_mensais) ?>;
const dadosOrigem  = <?= json_encode($dados_origem) ?>;

function formatarMoeda(valor) {
  if (valor === 0) return null;
  return valor.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' });
}

/* Linha: Evolução Mensal */
new Chart(document.getElementById('chartMensal').getContext('2d'), {
  type: 'line',
  data: {
    labels: ['Jan','Fev','Mar','Abr','Mai','Jun','Jul','Ago','Set','Out','Nov','Dez'],
    datasets: [
      {
        label: 'Receitas',
        data: dadosMensais.map(d => d.receitas),
        borderColor: '#27ae60',
        backgroundColor: 'rgba(39,174,96,0.1)',
        tension: .4, borderWidth: 3
      },
      {
        label: 'Despesas',
        data: dadosMensais.map(d => d.despesas),
        borderColor: '#e74c3c',
        backgroundColor: 'rgba(231,76,60,0.1)',
        tension: .4, borderWidth: 3
      }
    ]
  },
  options: {
    responsive: true,
    plugins: {
      legend: { position: 'top' },
      datalabels: {
        align: 'end', anchor: 'end',
        backgroundColor: 'rgba(255,255,255,.7)', borderRadius: 4, padding: 4,
        font: { weight: 'bold', size: 10 },
        formatter: formatarMoeda
      }
    },
    scales: {
      y: {
        beginAtZero: true,
        ticks: { callback: v => v.toLocaleString('pt-BR',{style:'currency',currency:'BRL'}) }
      }
    }
  }
});

/* Rosca: Origem */
const cores = ['#3498db','#e74c3c','#f39c12','#9b59b6','#1abc9c','#34495e','#2ecc71','#8e44ad'];
new Chart(document.getElementById('chartOrigem').getContext('2d'), {
  type: 'doughnut',
  data: {
    labels: dadosOrigem.map(d => (d.origem || '').replace(/_/g,' ')),
    datasets: [{
      data: dadosOrigem.map(d => d.total),
      backgroundColor: cores, borderColor: '#fff', borderWidth: 3
    }]
  },
  options: {
    responsive: true,
    plugins: {
      legend: { position: 'bottom', labels: { padding: 20, font: { weight: 'bold' } } },
      datalabels: {
        color: '#fff', font: { weight: 'bold', size: 12 },
        formatter: v => v.toLocaleString('pt-BR',{style:'currency',currency:'BRL',minimumFractionDigits:0})
      }
    }
  }
});

/* Barras + linha: Comparativo */
new Chart(document.getElementById('chartComparativo').getContext('2d'), {
  type: 'bar',
  data: {
    labels: ['Jan','Fev','Mar','Abr','Mai','Jun','Jul','Ago','Set','Out','Nov','Dez'],
    datasets: [
      { label: 'Receitas',  data: dadosMensais.map(d => d.receitas),  backgroundColor:'rgba(39,174,96,.8)',  borderColor:'#27ae60', borderWidth:2 },
      { label: 'Despesas',  data: dadosMensais.map(d => d.despesas),  backgroundColor:'rgba(231,76,60,.8)',  borderColor:'#e74c3c', borderWidth:2 },
      { label: 'Saldo',     data: dadosMensais.map(d => d.receitas - d.despesas), type:'line', backgroundColor:'rgba(52,152,219,.0)', borderColor:'#3498db', borderWidth:3, fill:false,
        datalabels:{ display:false } }
    ]
  },
  options: {
    responsive: true,
    plugins: {
      legend: { position: 'top' },
      datalabels: {
        align:'end', anchor:'end', color:'#555',
        font:{ weight:'bold', size:10 },
        formatter: formatarMoeda
      }
    },
    scales: {
      y: {
        beginAtZero: true,
        ticks: { callback: v => v.toLocaleString('pt-BR',{style:'currency',currency:'BRL'}) }
      }
    }
  }
});
</script>

</body>
</html>
<?php if (isset($conexao) && $conexao instanceof mysqli) { $conexao->close(); } ?>