-- Script SQL para inserir 10 registros de eleitores
-- Execute este script no banco de dados gabinete_bd

USE gabinete_bd;

-- Inserindo 10 registros de eleitores com dados variados
INSERT INTO eleitores (nome_completo, data_nascimento, telefone, email, endereco, bairro, cidade, cep, sexo, tipo, observacao) VALUES
('Maria Silva Santos', '1985-03-15', '(91) 98765-4321', 'maria.silva@email.com', 'Rua das Flores, 123', 'Nazaré', 'Belém', '66035-100', 'Feminino', 'Apoiador', 'Moradora antiga do bairro, muito engajada nas questões comunitárias'),

('João Carlos Oliveira', '1978-07-22', '(91) 99876-5432', 'joao.carlos@email.com', 'Av. Presidente Vargas, 456', 'Campina', 'Belém', '66017-000', 'Masculino', 'Liderança', 'Presidente da associação de moradores'),

('Ana Paula Costa', '1992-11-08', '(91) 97654-3210', 'ana.paula@email.com', 'Travessa Dom Pedro I, 789', 'Cidade Velha', 'Belém', '66020-160', 'Feminino', 'Apoiador', 'Professora da rede municipal'),

('Carlos Eduardo Lima', '1980-05-30', '(91) 96543-2109', 'carlos.eduardo@email.com', 'Rua Boaventura da Silva, 321', 'Reduto', 'Belém', '66053-170', 'Masculino', 'Apoiador', 'Comerciante local, dono de padaria'),

('Fernanda Rodrigues', '1987-09-12', '(91) 95432-1098', 'fernanda.rodrigues@email.com', 'Rua dos Tamoios, 654', 'Batista Campos', 'Belém', '66023-540', 'Feminino', 'Liderança', 'Coordenadora de projetos sociais'),

('Roberto Almeida', '1975-12-03', '(91) 94321-0987', 'roberto.almeida@email.com', 'Av. Nazaré, 987', 'Nazaré', 'Belém', '66035-170', 'Masculino', 'Apoiador', 'Aposentado, ex-funcionário público'),

('Juliana Pereira', '1990-04-18', '(91) 93210-9876', 'juliana.pereira@email.com', 'Rua Aristides Lobo, 147', 'Reduto', 'Belém', '66053-190', 'Feminino', 'Apoiador', 'Enfermeira do Hospital Municipal'),

('Antonio José Silva', '1983-08-25', '(91) 92109-8765', 'antonio.jose@email.com', 'Travessa Frutuoso Guimarães, 258', 'Campina', 'Belém', '66017-080', 'Masculino', 'Liderança', 'Líder comunitário, organiza eventos no bairro'),

('Patrícia Mendes', '1995-01-14', '(91) 91098-7654', 'patricia.mendes@email.com', 'Rua Santo Antônio, 369', 'Cidade Velha', 'Belém', '66020-170', 'Feminino', 'Apoiador', 'Estudante universitária, curso de Direito'),

('Marcos Vinícius Santos', '1988-06-07', '(91) 90987-6543', 'marcos.vinicius@email.com', 'Av. São Jerônimo, 741', 'Batista Campos', 'Belém', '66023-580', 'Masculino', 'Apoiador', 'Engenheiro civil, trabalha em construtora local');

-- Verificar se os registros foram inseridos
SELECT COUNT(*) as 'Total de Eleitores Inseridos' FROM eleitores WHERE nome_completo IN (
    'Maria Silva Santos',
    'João Carlos Oliveira', 
    'Ana Paula Costa',
    'Carlos Eduardo Lima',
    'Fernanda Rodrigues',
    'Roberto Almeida',
    'Juliana Pereira',
    'Antonio José Silva',
    'Patrícia Mendes',
    'Marcos Vinícius Santos'
);

-- Inserir demandas associadas aos eleitores cadastrados
INSERT INTO demandas (id_eleitor, titulo, descricao, categoria, status, data_abertura) VALUES
-- Maria Silva Santos - Saúde
((SELECT id FROM eleitores WHERE nome_completo = 'Maria Silva Santos'), 'Consulta médica especializada', 'Necessita de consulta com cardiologista', 'Saúde', 'Aberta', '2024-01-15'),

-- João Carlos Oliveira - Assistência Social  
((SELECT id FROM eleitores WHERE nome_completo = 'João Carlos Oliveira'), 'Melhorias no bairro', 'Solicitação de melhorias na iluminação pública', 'Assistência Social', 'Em Andamento', '2024-01-10'),

-- Ana Paula Costa - Jurídico
((SELECT id FROM eleitores WHERE nome_completo = 'Ana Paula Costa'), 'Orientação jurídica trabalhista', 'Precisa de orientação sobre direitos trabalhistas', 'Jurídico', 'Aberta', '2024-01-20'),

-- Carlos Eduardo Lima - Moradia
((SELECT id FROM eleitores WHERE nome_completo = 'Carlos Eduardo Lima'), 'Regularização de imóvel', 'Documentação para regularização de terreno', 'Moradia', 'Aberta', '2024-01-18'),

-- Fernanda Rodrigues - Ação Social
((SELECT id FROM eleitores WHERE nome_completo = 'Fernanda Rodrigues'), 'Projeto social comunitário', 'Organização de projeto para crianças carentes', 'Ação Social', 'Em Andamento', '2024-01-12'),

-- Roberto Almeida - Saúde
((SELECT id FROM eleitores WHERE nome_completo = 'Roberto Almeida'), 'Medicamentos de alto custo', 'Solicitação de medicamentos para diabetes', 'Saúde', 'Aberta', '2024-01-22'),

-- Juliana Pereira - Ação Saúde
((SELECT id FROM eleitores WHERE nome_completo = 'Juliana Pereira'), 'Campanha de vacinação', 'Organização de campanha no bairro', 'Ação Saúde', 'Em Andamento', '2024-01-14'),

-- Antonio José Silva - Fiscalização
((SELECT id FROM eleitores WHERE nome_completo = 'Antonio José Silva'), 'Fiscalização de obras públicas', 'Acompanhamento de obras no bairro', 'Fiscalização', 'Aberta', '2024-01-16'),

-- Patrícia Mendes - Jurídico
((SELECT id FROM eleitores WHERE nome_completo = 'Patrícia Mendes'), 'Orientação para estágio', 'Orientação jurídica para estágio obrigatório', 'Jurídico', 'Aberta', '2024-01-25'),

-- Marcos Vinícius Santos - Reunião
((SELECT id FROM eleitores WHERE nome_completo = 'Marcos Vinícius Santos'), 'Reunião sobre infraestrutura', 'Discussão sobre melhorias urbanas', 'Reunião', 'Aberta', '2024-01-19');

-- Mostrar os registros inseridos com suas demandas
SELECT 
    e.id, 
    e.nome_completo, 
    e.telefone, 
    e.bairro, 
    e.sexo, 
    e.tipo,
    d.categoria as categoria_demanda,
    d.titulo as titulo_demanda,
    d.status as status_demanda
FROM eleitores e
LEFT JOIN demandas d ON e.id = d.id_eleitor
WHERE e.nome_completo IN (
    'Maria Silva Santos',
    'João Carlos Oliveira', 
    'Ana Paula Costa',
    'Carlos Eduardo Lima',
    'Fernanda Rodrigues',
    'Roberto Almeida',
    'Juliana Pereira',
    'Antonio José Silva',
    'Patrícia Mendes',
    'Marcos Vinícius Santos'
)
ORDER BY e.nome_completo;