-- Script para atualizar a tabela documentos para suportar fotos e vídeos publicitários
-- Execute este script no seu banco de dados MySQL

USE gabinete;

-- Adicionar novas categorias à tabela documentos
ALTER TABLE `documentos` 
MODIFY COLUMN `categoria` ENUM(
    'Ofício', 
    'Requerimento', 
    'Projetos', 
    'Prestação de Contas', 
    'Diversos',
    'Foto Publicitária',
    'Vídeo Publicitário',
    'Material de Campanha',
    'Peça Gráfica'
) NOT NULL;

-- Adicionar campos específicos para mídia
ALTER TABLE `documentos` 
ADD COLUMN `tipo_midia` ENUM('documento', 'imagem', 'video') DEFAULT 'documento' AFTER `categoria`,
ADD COLUMN `largura` INT NULL COMMENT 'Largura da imagem/vídeo em pixels' AFTER `tipo_midia`,
ADD COLUMN `altura` INT NULL COMMENT 'Altura da imagem/vídeo em pixels' AFTER `largura`,
ADD COLUMN `duracao` INT NULL COMMENT 'Duração do vídeo em segundos' AFTER `altura`,
ADD COLUMN `thumbnail` VARCHAR(255) NULL COMMENT 'Caminho para miniatura do vídeo' AFTER `duracao`,
ADD COLUMN `tags` TEXT NULL COMMENT 'Tags separadas por vírgula para busca' AFTER `thumbnail`,
ADD COLUMN `evento_campanha` VARCHAR(255) NULL COMMENT 'Nome do evento ou campanha relacionada' AFTER `tags`;

-- Criar índices para melhor performance
CREATE INDEX idx_tipo_midia ON documentos(tipo_midia);
CREATE INDEX idx_categoria_tipo ON documentos(categoria, tipo_midia);
CREATE INDEX idx_data_upload ON documentos(data_upload DESC);

-- Verificar a estrutura atualizada
DESCRIBE documentos;

SELECT 'Tabela documentos atualizada com sucesso para suportar multimídia!' as status;