<?php
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../helpers/AuthHelper.php';
require_once __DIR__ . '/../../models/Documento.php';

// Verificar se usuário está logado
AuthHelper::check();

// Verificar se é uma requisição POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: ' . BASE_URL . '/documentos');
    exit;
}

// Verificar se o ID foi fornecido
if (!isset($_POST['id']) || empty($_POST['id'])) {
    $_SESSION['error'] = 'ID do documento não fornecido';
    header('Location: ' . BASE_URL . '/documentos');
    exit;
}

$id = (int)$_POST['id'];
$documentoModel = new Documento();

try {
    // Verificar se o documento existe
    $documento = $documentoModel->findById($id);
    if (!$documento) {
        $_SESSION['error'] = 'Documento não encontrado';
        header('Location: ' . BASE_URL . '/documentos');
        exit;
    }
    
    // Excluir o documento
    if ($documentoModel->delete($id)) {
        $_SESSION['success'] = 'Documento excluído com sucesso!';
    } else {
        $_SESSION['error'] = 'Erro ao excluir documento';
    }
    
} catch (Exception $e) {
    $_SESSION['error'] = 'Erro: ' . $e->getMessage();
}

// Redirecionar de volta para a lista de documentos
header('Location: ' . BASE_URL . '/documentos');
exit;
?>