<?php
/**
 * View para listagem de Material Publicitário
 */
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Material Publicitário - Gabinete</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .material-card {
            transition: transform 0.2s;
            border: 1px solid #dee2e6;
        }
        .material-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .material-thumbnail {
            width: 100%;
            height: 200px;
            object-fit: cover;
            border-radius: 8px;
        }
        .video-thumbnail {
            position: relative;
        }
        .video-play-icon {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-size: 3rem;
            color: white;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.7);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav class="col-md-2 d-none d-md-block bg-light sidebar">
                <div class="sidebar-sticky">
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link" href="<?= BASE_URL ?>/documentos">
                                <i class="fas fa-file-alt"></i> Documentos
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="<?= BASE_URL ?>/material-publicitario">
                                <i class="fas fa-images"></i> Material Publicitário
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>

            <!-- Main content -->
            <main class="col-md-10 ml-sm-auto px-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Material Publicitário</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#uploadModal">
                            <i class="fas fa-plus"></i> Novo Material
                        </button>
                    </div>
                </div>

                <?php if (isset($_SESSION['success'])): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= $_SESSION['success'] ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    <?php unset($_SESSION['success']); ?>
                <?php endif; ?>

                <?php if (isset($_SESSION['error'])): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= $_SESSION['error'] ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    <?php unset($_SESSION['error']); ?>
                <?php endif; ?>

                <!-- Filtros -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <select class="form-select" id="filtroTipo">
                            <option value="">Todas as categorias</option>
                            <option value="Banner Digital">Banner Digital</option>
                            <option value="Cartaz Impresso">Cartaz Impresso</option>
                            <option value="Flyer">Flyer</option>
                            <option value="Post Redes Sociais">Post Redes Sociais</option>
                            <option value="Vídeo Promocional">Vídeo Promocional</option>
                            <option value="Spot Rádio">Spot Rádio</option>
                            <option value="Material TV">Material TV</option>
                            <option value="Outdoor">Outdoor</option>
                            <option value="Busdoor">Busdoor</option>
                            <option value="Adesivo">Adesivo</option>
                            <option value="Santinho">Santinho</option>
                            <option value="Folder">Folder</option>
                            <option value="Panfleto">Panfleto</option>
                            <option value="Outros">Outros</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <input type="text" class="form-control" id="busca" placeholder="Buscar por título ou descrição...">
                    </div>
                </div>

                <!-- Grid de materiais -->
                <div class="row" id="materiaisGrid">
                    <?php if (!empty($materiais)): ?>
                        <?php foreach ($materiais as $material): ?>
                            <div class="col-md-4 col-lg-3 mb-4 material-item" data-categoria="<?= htmlspecialchars($material['categoria']) ?>" data-titulo="<?= htmlspecialchars($material['titulo']) ?>" data-descricao="<?= htmlspecialchars($material['descricao']) ?>">
                                <div class="card material-card h-100">
                                    <div class="card-body p-2">
                                        <?php if (strpos($material['tipo_arquivo'], 'image/') === 0): ?>
                                            <img src="<?= BASE_URL ?>/material-publicitario/visualizar/<?= $material['id'] ?>" 
                                                 class="material-thumbnail" 
                                                 alt="<?= htmlspecialchars($material['titulo']) ?>">
                                        <?php elseif (strpos($material['tipo_arquivo'], 'video/') === 0): ?>
                                            <div class="video-thumbnail">
                                                <video class="material-thumbnail" muted>
                                                    <source src="<?= BASE_URL ?>/material-publicitario/visualizar/<?= $material['id'] ?>" type="<?= $material['tipo_arquivo'] ?>">
                                                </video>
                                                <i class="fas fa-play-circle video-play-icon"></i>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <div class="mt-2">
                                            <h6 class="card-title mb-1"><?= htmlspecialchars($material['titulo']) ?></h6>
                                            <p class="card-text small text-muted mb-2"><?= htmlspecialchars($material['descricao']) ?></p>
                                            <small class="text-muted">
                                                <i class="fas fa-calendar"></i> <?= date('d/m/Y', strtotime($material['data_upload'])) ?>
                                            </small>
                                        </div>
                                    </div>
                                    <div class="card-footer bg-transparent p-2">
                                        <div class="btn-group w-100" role="group">
                                            <a href="<?= BASE_URL ?>/material-publicitario/visualizar/<?= $material['id'] ?>" 
                                               class="btn btn-sm btn-outline-primary" target="_blank">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?= BASE_URL ?>/material-publicitario/download/<?= $material['id'] ?>" 
                                               class="btn btn-sm btn-outline-success">
                                                <i class="fas fa-download"></i>
                                            </a>
                                            <button class="btn btn-sm btn-outline-danger" 
                                                    onclick="confirmarExclusao(<?= $material['id'] ?>)">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="col-12">
                            <div class="text-center py-5">
                                <i class="fas fa-images fa-3x text-muted mb-3"></i>
                                <h4 class="text-muted">Nenhum material encontrado</h4>
                                <p class="text-muted">Faça upload do primeiro material publicitário.</p>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </main>
        </div>
    </div>

    <!-- Modal de Upload -->
    <div class="modal fade" id="uploadModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="<?= BASE_URL ?>/material-publicitario/upload" method="POST" enctype="multipart/form-data">
                    <div class="modal-header">
                        <h5 class="modal-title">Novo Material Publicitário</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="titulo" class="form-label">Título *</label>
                            <input type="text" class="form-control" id="titulo" name="titulo" required>
                        </div>
                        <div class="mb-3">
                            <label for="descricao" class="form-label">Descrição</label>
                            <textarea class="form-control" id="descricao" name="descricao" rows="3"></textarea>
                        </div>
                        <div class="mb-3">
                            <label for="tipo" class="form-label">Tipo *</label>
                            <select class="form-select" id="categoria" name="categoria" required>
                                <option value="">Selecione a categoria</option>
                                <option value="Banner Digital">Banner Digital</option>
                                <option value="Cartaz Impresso">Cartaz Impresso</option>
                                <option value="Flyer">Flyer</option>
                                <option value="Post Redes Sociais">Post Redes Sociais</option>
                                <option value="Vídeo Promocional">Vídeo Promocional</option>
                                <option value="Spot Rádio">Spot Rádio</option>
                                <option value="Material TV">Material TV</option>
                                <option value="Outdoor">Outdoor</option>
                                <option value="Busdoor">Busdoor</option>
                                <option value="Adesivo">Adesivo</option>
                                <option value="Santinho">Santinho</option>
                                <option value="Folder">Folder</option>
                                <option value="Panfleto">Panfleto</option>
                                <option value="Outros">Outros</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="arquivo" class="form-label">Arquivo *</label>
                            <input type="file" class="form-control" id="arquivo" name="arquivo" 
                                   accept="image/*,video/*" required>
                            <div class="form-text">Formatos aceitos: JPG, PNG, GIF, MP4, AVI, MOV (máx. 50MB)</div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Fazer Upload</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Filtros
        document.getElementById('filtroTipo').addEventListener('change', filtrarMateriais);
        document.getElementById('busca').addEventListener('input', filtrarMateriais);

        function filtrarMateriais() {
            const categoria = document.getElementById('filtroTipo').value;
            const busca = document.getElementById('busca').value.toLowerCase();
            const items = document.querySelectorAll('.material-item');

            items.forEach(item => {
                const itemCategoria = item.dataset.categoria;
                const itemTitulo = item.dataset.titulo.toLowerCase();
                const itemDescricao = item.dataset.descricao.toLowerCase();

                const matchCategoria = !categoria || itemCategoria === categoria;
                const matchBusca = !busca || itemTitulo.includes(busca) || itemDescricao.includes(busca);

                item.style.display = matchCategoria && matchBusca ? 'block' : 'none';
            });
        }

        function confirmarExclusao(id) {
            if (confirm('Tem certeza que deseja excluir este material?')) {
                window.location.href = `<?= BASE_URL ?>/material-publicitario/excluir/${id}`;
            }
        }
    </script>
</body>
</html>